package com.nsftools.charthelper;

/*
 * copyright 2009 SNAPPS, Julian Robichaux, and Rob McDonagh
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 2.1 of the License, or
 *     (at your option) any later version.
 *                 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *     
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this program.  If not, see http://www.gnu.org/licenses.
 */


import org.jfree.chart.*;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import java.awt.Font;


public class PieChartWrapper extends GenericChartWrapper {
	
	public void addData (double value, String label, String unused) {
		((DefaultPieDataset)data).setValue(label, new Double(value));
		dataChanged = true;
	}
	
	
	public void clearData () {
		data = new DefaultPieDataset();
		showLegend = true;
		dataChanged = true;
	}
	
	
	public void dispose () {
		try {
			PiePlot3D plot = (PiePlot3D)chart.getPlot();
			plot.setDataset(null);
		} catch (Exception e) {
		} finally {
			super.dispose();
		}
	}
	
	
	protected void createChart () {
		if ((chart == null) || dataChanged) {
			chart = ChartFactory.createPieChart3D(chartTitle, 
					(DefaultPieDataset)data, showLegend, false, false);
			chart.setNotify(false);
			
			// this is what creates the cool transparency effect
			PiePlot3D pieplot3d = (PiePlot3D)chart.getPlot();
			pieplot3d.setForegroundAlpha(0.5F);
			pieplot3d.setToolTipGenerator(null);
			
			font = Font.decode("Arial-PLAIN-10");
			pieplot3d.setLabelFont( font );
			
			if (showLegend)
				chart.getLegend().setItemFont( font );
			
			font = null;
			font = Font.decode("Arial-BOLD-18");
			chart.getTitle().setFont( font );
			font = null;
			
			dataChanged = false;
		}
	}
		
}
