package com.nsftools.charthelper;

/*
 * copyright 2009 SNAPPS, Julian Robichaux, and Rob McDonagh
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 2.1 of the License, or
 *     (at your option) any later version.
 *                 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *     
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this program.  If not, see http://www.gnu.org/licenses.
 */


import org.jfree.chart.*;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.*;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import java.awt.Font;
import java.text.DecimalFormat;

public class LineChartWrapper extends GenericChartWrapper {
	 
	public void addData (double value, String dataLabel, String lineName) {
		((DefaultCategoryDataset)data).addValue(value, lineName, dataLabel);
		dataChanged = true;
	}
	
	
	public void clearData () {
		data = new DefaultCategoryDataset();
		showLegend = true;
		dataChanged = true;
	}
	
	
	public void dispose () {
		try {
			CategoryPlot plot = (CategoryPlot)chart.getPlot();
			plot.setDataset(null);
		} catch (Exception e) {
		} finally {
			super.dispose();
		}
	}
	
	
	protected void createChart () {
		if ((chart == null) || dataChanged) {
			chart = ChartFactory.createLineChart(chartTitle, 
					verticalAxisLabel, horizontalAxisLabel, 
					(DefaultCategoryDataset)data, 
					PlotOrientation.VERTICAL, true, false, false);
			chart.setNotify(false);
			
			font = Font.decode("Arial-PLAIN-10");
			CategoryPlot plot = (CategoryPlot)chart.getPlot();
			NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
			yAxis.setLabelFont( font );
			yAxis.setTickLabelFont( font );
			//yAxis.setNumberFormatOverride( new DecimalFormat("#,##0") );
			CategoryAxis xAxis = plot.getDomainAxis();
			if (showLegend) {
				xAxis.setLabelFont( font );
				xAxis.setTickLabelFont( font );
				xAxis.setCategoryLabelPositions(
						CategoryLabelPositions.createUpRotationLabelPositions(30 * (Math.PI / 180)));
			} else {
				xAxis.setVisible(false);
			}
			
			LineAndShapeRenderer renderer = (LineAndShapeRenderer) plot.getRenderer();
			renderer.setStroke( new java.awt.BasicStroke(3f, 
					java.awt.BasicStroke.JOIN_ROUND, 
					java.awt.BasicStroke.JOIN_BEVEL));
			drawMarker(plot, font);
			
			// always show the legend if there's more than one data line
			if (plot.getLegendItems().getItemCount() > 1) {
				chart.getLegend().setItemFont( font );
			} else {
				chart.getLegend().setVisible(false);
			}
			
			font = null;
			font = Font.decode("Arial-BOLD-18");
			chart.getTitle().setFont( font );
			font = null;
			
			dataChanged = false;
		}
	}
	
}

