package com.nsftools.charthelper;

/*
 * copyright 2009 SNAPPS, Julian Robichaux, and Rob McDonagh
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 2.1 of the License, or
 *     (at your option) any later version.
 *                 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *     
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this program.  If not, see http://www.gnu.org/licenses.
 */


import org.jfree.chart.*;
import org.jfree.chart.plot.*;
import org.jfree.data.category.DefaultCategoryDataset;
import java.awt.Font;

public class BarChart3DWrapper extends GenericChartWrapper {
	 
	public void addData (double value, String columnLabel, String groupLabel) {
		((DefaultCategoryDataset)data).addValue(value, columnLabel, groupLabel);
		dataChanged = true;
	}
	
	
	public void clearData () {
		data = new DefaultCategoryDataset();
		showLegend = true;
		dataChanged = true;
	}
	
	
	public void dispose () {
		try {
			CategoryPlot plot = (CategoryPlot)chart.getPlot();
			plot.setDataset(null);
		} catch (Exception e) {
		} finally {
			super.dispose();
		}
	}
	
	
	protected void createChart () {
		if ((chart == null) || dataChanged) {
			chart = ChartFactory.createBarChart3D(chartTitle, 
					verticalAxisLabel, horizontalAxisLabel, 
					(DefaultCategoryDataset)data, 
					PlotOrientation.VERTICAL, showLegend, false, false);
			chart.setNotify(false);
			
			font = Font.decode("Arial-PLAIN-10");
			CategoryPlot plot = (CategoryPlot)chart.getPlot();
			plot.getRangeAxis().setLabelFont( font );
			plot.getRangeAxis().setTickLabelFont( font );
			plot.getDomainAxis().setLabelFont( font );
			plot.getDomainAxis().setTickLabelFont( font );
			
			// the marker is kinda ugly on the 3-D chart, so we'll skip it
			//drawMarker(plot, font);
			
			if (showLegend)
				chart.getLegend().setItemFont( font );
			
			font = null;
			font = Font.decode("Arial-BOLD-18");
			chart.getTitle().setFont( font );
			font = null;
			
			dataChanged = false;
		}
	}
	
}

