package com.ibm.lotuslabs.context.service.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

import com.ibm.lotuslabs.context.service.document.IDocumentContext;
import com.ibm.rcp.jface.launcher.IURIProvider;

/**
 * Extracts document information about about a selection object.
 * Represents the document within the DocumentSelection.
 * 
 * @author bleonard
 */
public class DocumentContext implements IDocumentContext {

	private IWorkbenchPart part;
	private Object obj;
	private String label;
	private URI uri;
	private ImageDescriptor icon;
	private Properties properties;	

	/**
	 * Tries to map these things into an IDocumentContext
	 * @param part	current viewpart
	 * @param obj	selected object
	 */
	public DocumentContext(IWorkbenchPart part, Object obj) {
		this.part = part;
		this.obj = obj;

		IURIProvider provider = (IURIProvider) ContextUtil.getAdapterObject(obj, IURIProvider.class);
		if(provider!=null) {
			this.uri = provider.getURI();
			this.label = provider.getTitle();
			this.icon = provider.getImageDescriptor();
		}

		if(this.label==null || this.icon==null) {
			// can this thing be a workbench adapter?
			IWorkbenchAdapter wba = (IWorkbenchAdapter) ContextUtil.getAdapterObject(obj, IWorkbenchAdapter.class);
			if(wba!=null) {
				if(this.label!=null)
					this.label = wba.getLabel(obj);
				if(this.icon!=null)
					this.icon = wba.getImageDescriptor(obj);
			}
			if(this.icon==null) {
				Image i = part.getTitleImage();
				if(i!=null)
					this.icon = ImageDescriptor.createFromImage(i);
			}
		}

		// can this thing be a uri?
		if(uri==null)
			uri = (URI) ContextUtil.getAdapterObject(obj, URI.class);

		// can this thing be a property source?
		IPropertySource prop = (IPropertySource) ContextUtil.getAdapterObject(obj, IPropertySource.class);
		if(prop!=null)
			properties = buildProperties(prop);	// fills up any non-null data
	}

	private Properties buildProperties(IPropertySource source) {
		if(source==null)
			return null;
		IPropertyDescriptor[] descs = source.getPropertyDescriptors();
		if(descs==null || descs.length==0)
			return null;

		Properties prop = new Properties();
		for(int i=0;i<descs.length;i++) {
			Object id = descs[i].getId();
			String name = descs[i].getDisplayName();
			String value = source.getPropertyValue(descs[i].getId()).toString();

			if(this.uri==null) {
				if(((id!=null && id.toString().equalsIgnoreCase("URI"))
						|| (name!=null && name.equalsIgnoreCase("URI"))) ||
						((id!=null && id.toString().equalsIgnoreCase("URL"))
								|| (name!=null && name.equalsIgnoreCase("URL")))) {
					try {
						this.uri = new URI(value);
						continue;
					} catch (URISyntaxException e) { }
				}
			}
			if(this.label==null) {
				// TODO: if prop isn't null, but label is, use prop to get label	
			}
			prop.setProperty(name, value);
		}
		return prop;
	}

	public Object getObject() {
		return obj;
	}

	public IWorkbenchPart getPart() {
		return part;
	}

	public ImageDescriptor getImageDescriptor() {
		return icon;
	}

	public String getLabel() {
		if(label==null && part!=null)
			return part.getTitle();
		return label;
	}

	public URI getURI() {
		return uri;
	}

	public Properties getProperties() {
		return properties;
	}
}
