package com.ibm.lotuslabs.context.service.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;

public class ContextUtil {
	/**
	 * Helper method to get the adapter for a given object
	 * @param o			the object
	 * @param clazz		what you want it to adapt to
	 * @return			Object of type clazz
	 */
	public static Object getAdapterObject(Object o, Class clazz) {
		Object item = null;
		if(clazz.isInstance(o))
			item = o;
		else if(o instanceof IAdaptable) {
			item = ((IAdaptable)o).getAdapter(clazz);
		}
		if(item==null) {
			IAdapterManager man = Platform.getAdapterManager();
			if(man!=null)
				item = man.getAdapter(o, clazz);
		}
		return item;
	}
}
