package com.ibm.lotuslabs.context.service.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

import com.ibm.lotuslabs.context.service.internal.ContextUtil;
import com.ibm.lotuslabs.context.service.internal.DocumentContext;

/**
 * Container for the selected documents.
 * 
 * @author bleonard
 */
public class DocumentSelection implements IStructuredSelection {
	
	private ISelection selection;
	private IWorkbenchPart part;
	private List items;
	
	/**
	 * @param part 			current ViewPart
	 * @param selection		current selection
	 */
	public DocumentSelection(IWorkbenchPart part, ISelection selection) {
		this.selection = selection;
		this.part = part;
		this.items = null;
	}
	
	/**
	 * @return  the original selection (not the stuff we derived from it)
	 */
	public ISelection getSelection(){
		return selection;
	}


	private List getItemList() {
		if(items==null)
			items = buildItems();
		return items;
	}
	
	/**
	 * Takes the current selection and viewpart and tries to derive ICleintItem
	 * objects from it.
	 * @return List of IClientItem objects
	 */
	private List buildItems() {	
		List list = new ArrayList();
		if(selection!=null && selection instanceof IStructuredSelection) {
			Object[] obj = ((IStructuredSelection)selection).toArray();
			for(int i=0; i<obj.length; i++) {
				IDocumentContext item = DocumentSelection.getDocumentContext(this.part,obj[i]);
				if(item!=null) {
					list.add(item);
				}
			}
		}
		else if(selection!=null) {
			IDocumentContext item = DocumentSelection.getDocumentContext(this.part,selection);
			if(item!=null) {
				list.add(item);
			}
		}
		
		if(list.size()==0 && this.part!=null) {
			// use the view part itself
			IDocumentContext item = DocumentSelection.getDocumentContext(part,part);
			if(item!=null) {
				list.add(item);
			}
		}
		return list;
	}	
	
	/**
	 * @return client items of this selection
	 */
	public IDocumentContext[] getItems() {
		List list = getItemList();
		return (IDocumentContext[]) list.toArray(new IDocumentContext[list.size()]);
	}


	/**
	 * Uses adapaters to map the current selection and part to an IClientItem
	 * @param part	current ViewPart
	 * @param o		Object we want a IClientItem for
	 * @return
	 */
	public static IDocumentContext getDocumentContext(IWorkbenchPart part, Object o) {
		IDocumentContext item = (IDocumentContext)ContextUtil.getAdapterObject(o,IDocumentContext.class);
		if(item==null) {
			IDocumentContextAdapter ad = (IDocumentContextAdapter) ContextUtil.getAdapterObject(o, IDocumentContextAdapter.class);
			if(ad!=null)
				item = ad.getDocumentContext(part, o);
		}		
		// use the default
		if(item==null)
			item = new DocumentContext(part,o);
		return item;
	}	
	
	
	// Implement ISelection
	public boolean isEmpty() {
		return getItemList().size()==0;
	}
	
	// Implement IStructedSelection
	public Object getFirstElement() {
		List list = getItemList();
		if(list.size()==0)
			return null;
		return list.get(0);
	}

	public Iterator iterator() {
		return getItemList().iterator();
	}
	
	public int size() {
		return getItemList().size();
	}

	public Object[] toArray() {
		return getItems();
	}

	public List toList() {
		return getItemList();
	}
}
