package acme.sidebarchart.views;

/*
 * copyright 2009 SNAPPS, Julian Robichaux, and Rob McDonagh
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 2.1 of the License, or
 *     (at your option) any later version.
 *                 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *     
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this program.  If not, see http://www.gnu.org/licenses.
 */

import com.nsftools.charthelper.ChartDataBean;

/**
 * An extension of the ChartDataBean class, used to store information
 * about a chart based on a Notes view, and for passing this data
 * around between classes.
 * 
 * @author Julian
 *
 */
public class ViewDataBean extends ChartDataBean {
	private int categoryColumn = 0;
	private int valueColumn = 0;
	private boolean selectAll = true;
	
	
	// override
	public void resetData () {
		selectAll = true;
		categoryColumn = 0;
		valueColumn = 0;
		super.resetData();
	}
	
	// override
	public void copyData (ViewDataBean vdb) {
		if (vdb == null) {
			resetData();
		} else {
			selectAll = vdb.isSelectAll();
			categoryColumn = vdb.getCategoryColumn();
			valueColumn = vdb.getValueColumn();
			super.copyData(vdb);
		}
	}
	
	// additional getters and setters specific to our sidebar app
	public int getCategoryColumn() {
		return categoryColumn;
	}
	public void setCategoryColumn(int categoryColumn) {
		this.categoryColumn = categoryColumn;
	}
	public boolean isSelectAll() {
		return selectAll;
	}
	public void setSelectAll(boolean selectAll) {
		this.selectAll = selectAll;
	}
	public int getValueColumn() {
		return valueColumn;
	}
	public void setValueColumn(int valueColumn) {
		this.valueColumn = valueColumn;
	}
	
}
